class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Rolling Stone'
    oldest_article = 14
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    keep_only_tags = [dict(name='div',attrs={'id':'col1'})]
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['assetContainer imageStandard floatLt','author','date','storyActions lowerArticleNav ','shareLinks','storyActions lowerArticleNav','reviewRatingsSection']}),
                   dict(name='div', attrs={'id':['comment_form_area','',]}),
                   dict(name='img'),]

    feeds = [
              (u'All News'      , u'http://www.rollingstone.com/siteServices/rss/allNews'      )
             ,(u'All Blogs'     , u'http://www.rollingstone.com/siteServices/rss/allBlogs'     )
             ,(u'Movie Reviews' , u'http://www.rollingstone.com/siteServices/rss/movieReviews' )
             ,(u'Album Reviews' , u'http://www.rollingstone.com/siteServices/rss/albumReviews' )
             ,(u'Song Reviews'  , u'http://www.rollingstone.com/siteServices/rss/songReviews'  )
            ]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup